/*
 * Decompiled with CFR 0.152.
 */
package jode.jvm;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;
import jode.jvm.InterpreterException;
import jode.jvm.RuntimeEnvironment;

public class SimpleRuntimeEnvironment
implements RuntimeEnvironment {
    public static Object fromReflectType(String string, Object object) {
        switch (string.charAt(0)) {
            case 'Z': {
                return new Integer((Boolean)object != false ? 1 : 0);
            }
            case 'B': 
            case 'S': {
                return new Integer(((Number)object).intValue());
            }
            case 'C': {
                return new Integer(((Character)object).charValue());
            }
        }
        return object;
    }

    public static Object toReflectType(String string, Object object) {
        switch (string.charAt(0)) {
            case 'Z': {
                return new Boolean((Integer)object != 0);
            }
            case 'B': {
                return new Byte(((Integer)object).byteValue());
            }
            case 'S': {
                return new Short(((Integer)object).shortValue());
            }
            case 'C': {
                return new Character((char)((Integer)object).intValue());
            }
        }
        return object;
    }

    public Object getField(Reference reference, Object object) throws InterpreterException {
        Field field;
        try {
            Class clazz = TypeSignature.getClass(reference.getClazz());
            try {
                field = clazz.getField(reference.getName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = clazz.getDeclaredField(reference.getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InterpreterException(reference + ": Class not found");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new InterpreterException("Constructor " + reference + " not found");
        }
        catch (SecurityException securityException) {
            throw new InterpreterException(reference + ": Security exception");
        }
        try {
            return SimpleRuntimeEnvironment.fromReflectType(reference.getType(), field.get(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InterpreterException("Field " + reference + " not accessible");
        }
    }

    public void putField(Reference reference, Object object, Object object2) throws InterpreterException {
        Field field;
        try {
            Class clazz = TypeSignature.getClass(reference.getClazz());
            try {
                field = clazz.getField(reference.getName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = clazz.getDeclaredField(reference.getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InterpreterException(reference + ": Class not found");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new InterpreterException("Constructor " + reference + " not found");
        }
        catch (SecurityException securityException) {
            throw new InterpreterException(reference + ": Security exception");
        }
        try {
            field.set(object, SimpleRuntimeEnvironment.toReflectType(reference.getType(), object2));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InterpreterException("Field " + reference + " not accessible");
        }
    }

    public Object invokeConstructor(Reference reference, Object[] objectArray) throws InterpreterException, InvocationTargetException {
        Constructor constructor;
        try {
            String[] stringArray = TypeSignature.getParameterTypes(reference.getType());
            Class clazz = TypeSignature.getClass(reference.getClazz());
            Class[] classArray = new Class[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                objectArray[n] = SimpleRuntimeEnvironment.toReflectType(stringArray[n], objectArray[n]);
                classArray[n] = TypeSignature.getClass(stringArray[n]);
                ++n;
            }
            try {
                constructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = clazz.getDeclaredConstructor(classArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InterpreterException(reference + ": Class not found");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InterpreterException("Constructor " + reference + " not found");
        }
        catch (SecurityException securityException) {
            throw new InterpreterException(reference + ": Security exception");
        }
        try {
            return constructor.newInstance(objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InterpreterException("Constructor " + reference + " not accessible");
        }
        catch (InstantiationException instantiationException) {
            throw new InterpreterException("InstantiationException in " + reference + ".");
        }
    }

    public Object invokeMethod(Reference reference, boolean bl, Object object, Object[] objectArray) throws InterpreterException, InvocationTargetException {
        Method method;
        Object object2;
        if (!bl && object != null) {
            throw new InterpreterException("Can't invoke nonvirtual Method " + reference + ".");
        }
        try {
            object2 = TypeSignature.getParameterTypes(reference.getType());
            Class clazz = TypeSignature.getClass(reference.getClazz());
            Class[] classArray = new Class[((String[])object2).length];
            int n = 0;
            while (n < ((String[])object2).length) {
                objectArray[n] = SimpleRuntimeEnvironment.toReflectType(object2[n], objectArray[n]);
                classArray[n] = TypeSignature.getClass(object2[n]);
                ++n;
            }
            try {
                method = clazz.getMethod(reference.getName(), classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getDeclaredMethod(reference.getName(), classArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InterpreterException(reference + ": Class not found");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InterpreterException("Method " + reference + " not found");
        }
        catch (SecurityException securityException) {
            throw new InterpreterException(reference + ": Security exception");
        }
        object2 = TypeSignature.getReturnType(reference.getType());
        try {
            return SimpleRuntimeEnvironment.fromReflectType((String)object2, method.invoke(object, objectArray));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InterpreterException("Method " + reference + " not accessible");
        }
    }

    public boolean instanceOf(Object object, String string) throws InterpreterException {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InterpreterException("Class " + classNotFoundException.getMessage() + " not found");
        }
        return object != null && !clazz.isInstance(object);
    }

    public Object newArray(String string, int[] nArray) throws InterpreterException, NegativeArraySizeException {
        Class clazz;
        try {
            clazz = TypeSignature.getClass(string.substring(nArray.length));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InterpreterException("Class " + classNotFoundException.getMessage() + " not found");
        }
        return Array.newInstance(clazz, nArray);
    }

    public void enterMonitor(Object object) throws InterpreterException {
        throw new InterpreterException("monitor not implemented");
    }

    public void exitMonitor(Object object) throws InterpreterException {
        throw new InterpreterException("monitor not implemented");
    }
}

